/*
 * Decompiled with CFR 0.152.
 */
package com.geope.recharge.activity;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.os.Bundle;
import android.view.MenuItem;
import android.view.View;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;
import androidx.annotation.NonNull;
import androidx.appcompat.app.ActionBarDrawerToggle;
import androidx.appcompat.app.AlertDialog;
import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.widget.Toolbar;
import androidx.drawerlayout.widget.DrawerLayout;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentTransaction;
import com.geope.recharge.AdsManager;
import com.geope.recharge.activity.MyApplication;
import com.geope.recharge.fragments.AboutFragment;
import com.geope.recharge.fragments.PrivacyFragment;
import com.geope.recharge.fragments.WebviewFragment;
import com.google.android.material.navigation.NavigationView;

public class MainActivity
extends AppCompatActivity
implements NavigationView.OnNavigationItemSelectedListener {
    private RelativeLayout no_internet;
    private Button Retrybtn;
    MyApplication myApplication;
    FrameLayout adContainerView;
    AdsManager.InterAdListener interAdListener;
    AdsManager adsManager;
    NavigationView navigationView;

    @SuppressLint(value={"SetJavaScriptEnabled"})
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(2131427356);
        Toolbar toolbar = (Toolbar)this.findViewById(2131231242);
        this.setSupportActionBar(toolbar);
        toolbar.setTitle((CharSequence)this.getResources().getString(2131820581));
        this.adsManager = AdsManager.getInstance();
        DrawerLayout drawer = (DrawerLayout)this.findViewById(2131230903);
        ActionBarDrawerToggle toggle = new ActionBarDrawerToggle((Activity)this, drawer, toolbar, 2131820756, 2131820755);
        drawer.addDrawerListener((DrawerLayout.DrawerListener)toggle);
        toggle.syncState();
        this.navigationView = (NavigationView)this.findViewById(2131231057);
        this.navigationView.setNavigationItemSelectedListener((NavigationView.OnNavigationItemSelectedListener)this);
        this.navigationView.setCheckedItem(2131231048);
        this.no_internet = (RelativeLayout)this.findViewById(2131231071);
        this.Retrybtn = (Button)this.findViewById(2131230727);
        this.adContainerView = (FrameLayout)this.findViewById(2131230792);
        this.checkConnection();
        this.myApplication = MyApplication.getInstance();
        if (savedInstanceState == null) {
            WebviewFragment fragment = null;
            fragment = WebviewFragment.newInstance(this.getResources().getString(2131820796));
            this.displaySelectedFragment(fragment);
        }
        this.Retrybtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                MainActivity.this.checkConnection();
            }
        });
        this.adsManager.loadInterAd((Activity)this);
        this.setAdsListener();
    }

    public boolean onNavigationItemSelected(@NonNull MenuItem menuItem) {
        int id2 = menuItem.getItemId();
        Object fragment = null;
        if (id2 == 2131231048) {
            this.adsManager.showInterAdOnClick((Activity)this, this.interAdListener, "nav_item_1");
        } else if (id2 == 2131231049) {
            this.adsManager.showInterAdOnClick((Activity)this, this.interAdListener, "nav_item_2");
        } else if (id2 == 2131231050) {
            this.adsManager.showInterAdOnClick((Activity)this, this.interAdListener, "nav_item_3");
        } else if (id2 == 2131231051) {
            this.adsManager.showInterAdOnClick((Activity)this, this.interAdListener, "nav_item_4");
        } else if (id2 == 2131231052) {
            this.adsManager.showInterAdOnClick((Activity)this, this.interAdListener, "nav_item_5");
        } else if (id2 == 2131231053) {
            this.adsManager.showInterAdOnClick((Activity)this, this.interAdListener, "nav_item_6");
        } else if (id2 == 2131231054) {
            this.adsManager.showInterAdOnClick((Activity)this, this.interAdListener, "nav_item_7");
        } else if (id2 == 2131231055) {
            this.adsManager.showInterAdOnClick((Activity)this, this.interAdListener, "nav_item_8");
        } else if (id2 == 2131231056) {
            this.finish();
        }
        DrawerLayout drawer = (DrawerLayout)this.findViewById(2131230903);
        drawer.closeDrawer(0x800003);
        return true;
    }

    void setAdsListener() {
        this.interAdListener = new AdsManager.InterAdListener(){

            @Override
            public void onClick(String type) {
                Fragment fragment = null;
                switch (type) {
                    case "nav_item_1": {
                        fragment = WebviewFragment.newInstance(MainActivity.this.getResources().getString(2131820796));
                        MainActivity.this.displaySelectedFragment(fragment);
                        break;
                    }
                    case "nav_item_2": {
                        fragment = WebviewFragment.newInstance(MainActivity.this.getResources().getString(2131820797));
                        MainActivity.this.displaySelectedFragment(fragment);
                        break;
                    }
                    case "nav_item_3": {
                        fragment = WebviewFragment.newInstance(MainActivity.this.getResources().getString(2131820798));
                        MainActivity.this.displaySelectedFragment(fragment);
                        break;
                    }
                    case "nav_item_4": {
                        fragment = WebviewFragment.newInstance(MainActivity.this.getResources().getString(2131820799));
                        MainActivity.this.displaySelectedFragment(fragment);
                        break;
                    }
                    case "nav_item_5": {
                        Uri uri = Uri.parse((String)("market://details?id=" + MainActivity.this.getApplication().getPackageName()));
                        Intent goToMarket = new Intent("android.intent.action.VIEW", uri);
                        goToMarket.addFlags(0x48080000);
                        try {
                            MainActivity.this.startActivity(goToMarket);
                        }
                        catch (ActivityNotFoundException e) {
                            MainActivity.this.startActivity(new Intent("android.intent.action.VIEW", Uri.parse((String)("http://play.google.com/store/apps/details?id=" + MainActivity.this.getApplication().getPackageName()))));
                        }
                        break;
                    }
                    case "nav_item_6": {
                        Intent shareIntent = new Intent("android.intent.action.SEND");
                        shareIntent.setType("text/plain");
                        shareIntent.putExtra("android.intent.extra.SUBJECT", MainActivity.this.getResources().getString(2131820581));
                        String shareMessage = "Let me recommend you this application\n\n";
                        shareMessage = shareMessage + "https://play.google.com/store/apps/details?id=" + "com.geope.recharge";
                        shareIntent.putExtra("android.intent.extra.TEXT", shareMessage);
                        MainActivity.this.startActivity(Intent.createChooser((Intent)shareIntent, (CharSequence)"choose one"));
                        break;
                    }
                    case "nav_item_7": {
                        fragment = new PrivacyFragment();
                        MainActivity.this.displaySelectedFragment(fragment);
                        break;
                    }
                    case "nav_item_8": {
                        fragment = new AboutFragment();
                        MainActivity.this.displaySelectedFragment(fragment);
                    }
                }
            }
        };
    }

    public void onBackPressed() {
        DrawerLayout drawer = (DrawerLayout)this.findViewById(2131230903);
        if (drawer.isDrawerOpen(0x800003)) {
            drawer.closeDrawer(0x800003);
        } else {
            this.openQuitDialog();
        }
    }

    public void openQuitDialog() {
        AlertDialog.Builder alert = new AlertDialog.Builder((Context)this);
        alert.setTitle(2131820581);
        alert.setIcon(2131623936);
        alert.setMessage((CharSequence)this.getString(2131820793));
        alert.setPositiveButton(2131820622, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int whichButton) {
                MainActivity.this.finish();
            }
        });
        alert.setNegativeButton((CharSequence)this.getString(2131820596), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
            }
        });
        alert.show();
    }

    private void displaySelectedFragment(Fragment fragment) {
        FragmentTransaction fragmentTransaction = this.getSupportFragmentManager().beginTransaction();
        fragmentTransaction.replace(2131230938, fragment);
        fragmentTransaction.commit();
    }

    public void checkConnection() {
        ConnectivityManager connectivityManager = (ConnectivityManager)this.getSystemService("connectivity");
        NetworkInfo wifi = connectivityManager.getNetworkInfo(1);
        NetworkInfo mobileNetwork = connectivityManager.getNetworkInfo(0);
        if (wifi.isConnected()) {
            this.no_internet.setVisibility(8);
        } else if (mobileNetwork.isConnected()) {
            this.no_internet.setVisibility(8);
        } else {
            this.no_internet.setVisibility(0);
        }
    }

    private void updateAds() {
        this.adsManager.showBannerAd((Activity)this, this.adContainerView);
    }

    protected void onPause() {
        super.onPause();
        this.adsManager.destroyBannerAds();
    }

    protected void onResume() {
        super.onResume();
        this.updateAds();
    }

    protected void onDestroy() {
        this.adsManager.destroyInterAds();
        super.onDestroy();
    }
}

