<?php
include("config.php");
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Manage Sales - Dyne Foundation</title>

  <!-- Google Font: Source Sans Pro -->
  <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700&display=fallback">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="plugins/fontawesome-free/css/all.min.css">
  <!-- DataTables -->
  <link rel="stylesheet" href="plugins/datatables-bs4/css/dataTables.bootstrap4.min.css">
  <link rel="stylesheet" href="plugins/datatables-responsive/css/responsive.bootstrap4.min.css">
  <link rel="stylesheet" href="plugins/datatables-buttons/css/buttons.bootstrap4.min.css">
  <!-- Theme style -->
  <link rel="stylesheet" href="dist/css/adminlte.min.css">
</head>
<body class="hold-transition sidebar-mini layout-fixed">
<div class="wrapper">
  <!-- Navbar -->
  <?php include("header.php");?>
  <!-- /.navbar -->

  <!-- Main Sidebar Container -->
  <aside class="main-sidebar sidebar-dark-primary elevation-4">
    <?php include("sidebar.php");?>
  </aside>

  <!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1>Manage Sales</h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="dashboard.php">Home</a></li>
              <li class="breadcrumb-item active">Manage Sales</li>
            </ol>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>

    <!-- Main content -->
    <section class="content">
      <div class="container-fluid">
        <div class="row">
          <div class="col-12">
            

            <div class="card">
              <div class="card-header col-12 row d-flex justify-content-between align-items-center">
                  <div class="col-6">
                      <h3 class="card-title">View All Sales Data</h3>
                  </div>
                <div class="col-6 d-flex justify-content-end">
                    <a class="btn btn-primary" href="newSalesData.php">+ Add New Data</a>
                </div>
                
              </div>
              <!-- /.card-header -->
              <div class="card-body">
                <table id="example1" class="table table-bordered table-striped">
                  <thead>
                  <tr>
                      <th>DO</th>
                    <th>DO No</th>
                    <th>Date</th>
                    <th>Challan</th>
                    <th>Dealer</th>
                    <th>Crop</th>
                    <th>HSN</th>
                    
                    <th>Lot No</th>
                    <th>Package (in kgs)</th>
                    <th>Bags</th>
                    <th>Packets</th>
                    <th>Qty</th>
                    <th>Rate</th>
                    <th>Payable</th>
                    <th>Total Bags</th>
                    <th>Total Packets</th>
                    <th>Net Qty</th>
                    
                    <th>Freight</th>
                    <th>Adv. Freight</th>
                    <th>To Pay Freight</th>
                    <th>Net Payable</th>
                    <th>Transport</th>
                    <th>Vehicle</th>
                  </tr>
                  </thead>
                  <tbody>
                      <?php
                      $sql=mysqli_query($db,"select * from sales_desc order by dono asc");
                      $nr=0;
                      if(mysqli_num_rows($sql))
                      {
                          while($row=mysqli_fetch_assoc($sql))
                          {
                              $grno=$row['dono'];
                              $pack=$row['package'];
                              
                                  $grsql=mysqli_query($db,"select * from sales where dono='$grno' ");
                              $grrow=mysqli_fetch_assoc($grsql);
                              
                              $grnsql=mysqli_query($db,"select * from sales_desc where dono='$grno' ");
                              $grnum=mysqli_num_rows($grnsql);
                              
                              
                              
                              
                              
                              $nr=$nr+1;
                              
                              
                              $afid=$grrow['did'];
                              
                              
                                  $asql=mysqli_query($db,"select name from dealers where id='$afid'");
                                  list($aname)=mysqli_fetch_row($asql);
                              
                              $crsql=mysqli_query($db,"select cropname from crops where id='".$row['cropid']."'");
                              list($cropname)=mysqli_fetch_row($crsql);
                              
                              $crvsql=mysqli_query($db,"select variety from cvariety where id='".$row['cropvar']."'");
                              list($crvname)=mysqli_fetch_row($crvsql);
                              
                              $pksql=mysqli_query($db,"select package from packages where id='$pack' ");
                              list($packname)=mysqli_fetch_row($pksql);
                              
                              $mlot=$row['mlot'];
                              
                              $mlsql=mysqli_query($db,"select mlot from manufacture where mnftid='$mlot' ");
                              list($mlt)=mysqli_fetch_row($mlsql);
                              
                              
                              ?>
                              <tr ondblclick="window.location.href='editSalesData.php?dono=<?php echo $grno;?>'">
                                  <td><?php echo $grno;?></td>
                       <td><?php echo "DO-".$grno;?></td>
                    
                    <td><?php
                    if($nr=="1")
                    {
                    echo $grrow['date'];
                    }
                    ?></td>
                    <td><?php
                    if($nr=="1")
                    {
                    echo $grrow['challan'];
                    }
                    ?></td>
                    <td><?php
                    if($nr=="1")
                    {
                    echo $aname;
                    }
                    ?></td>
                    <td><?php echo $cropname." - ".$crvname;?></td>
                    
                    <td><?php echo $row['hsn'];?></td>
                    
                    <td><?php echo $mlt;?></td>
                    <td><?php echo $packname;?></td>
                    <td><?php echo $row['bags'];?></td>
                    <td><?php echo $row['packs'];?></td>
                    <td><?php echo $row['qty'];?></td>
                    <td><?php echo $row['rate'];?></td>
                    <td><?php echo $row['payable'];?></td>
                    <td>
                            <?php
                            if($nr=="1")
                            {
                                echo $grrow['tbags'];
                            }
                            ?>
                        
                        </td>
                    
                        <td>
                            <?php
                            if($nr=="1")
                            {
                                echo $grrow['tpacks'];
                            }
                            ?>
                        
                        </td>
                        
                    
                    
                    <td>
                        <?php
                            if($nr=="1")
                            {
                                echo $grrow['tqty'];
                            }
                            ?>
                        
                    
                    </td>
                    <td>
                        <?php
                            if($nr=="1")
                            {
                                echo $grrow['freight'];
                            }
                            ?>
                        
                    
                    </td>
                    <td>
                        <?php
                            if($nr=="1")
                            {
                                echo $grrow['advfreight'];
                            }
                            ?>
                        
                    
                    </td>
                    <td>
                        <?php
                            if($nr=="1")
                            {
                                echo $grrow['topayfreight'];
                            }
                            ?>
                        
                    
                    </td>
                    <td>
                        <?php
                            if($nr=="1")
                            {
                                echo $grrow['netpay'];
                            }
                            ?>
                        
                    
                    </td>
                    <td>
                        <?php
                            if($nr=="1")
                            {
                                echo $grrow['transport'];
                            }
                            ?>
                        
                    
                    </td>
                    <td>
                        <?php
                            if($nr=="1")
                            {
                                echo $grrow['vehicle'];
                            }
                            ?>
                        
                    
                    </td>
                    
                    
                    
                    
                  </tr>
                              
                                  
                    
                    
                    
                    
                    
                    
                    
                    
                    
                    
                   
                                  <?php
                              if($nr==$grnum)
                              {
                                  $nr=0;
                              }
                          }
                      }
                      ?>
                  
                 
                </table>
              </div>
              <!-- /.card-body -->
            </div>
            <!-- /.card -->
          </div>
          <!-- /.col -->
        </div>
        <!-- /.row -->
      </div>
      <!-- /.container-fluid -->
    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->
  <footer class="main-footer">
    <?php include("footer.php");?>
  </footer>

  <!-- Control Sidebar -->
  <aside class="control-sidebar control-sidebar-dark">
    <!-- Control sidebar content goes here -->
  </aside>
  <!-- /.control-sidebar -->
</div>
<!-- ./wrapper -->

<!-- jQuery -->
<script src="plugins/jquery/jquery.min.js"></script>
<!-- Bootstrap 4 -->
<script src="plugins/bootstrap/js/bootstrap.bundle.min.js"></script>
<!-- DataTables  & Plugins -->
<script src="plugins/datatables/jquery.dataTables.min.js"></script>
<script src="plugins/datatables-bs4/js/dataTables.bootstrap4.min.js"></script>
<script src="plugins/datatables-responsive/js/dataTables.responsive.min.js"></script>
<script src="plugins/datatables-responsive/js/responsive.bootstrap4.min.js"></script>
<script src="plugins/datatables-buttons/js/dataTables.buttons.min.js"></script>
<script src="plugins/datatables-buttons/js/buttons.bootstrap4.min.js"></script>
<script src="plugins/jszip/jszip.min.js"></script>
<script src="plugins/pdfmake/pdfmake.min.js"></script>
<script src="plugins/pdfmake/vfs_fonts.js"></script>
<script src="plugins/datatables-buttons/js/buttons.html5.min.js"></script>
<script src="plugins/datatables-buttons/js/buttons.print.min.js"></script>
<script src="plugins/datatables-buttons/js/buttons.colVis.min.js"></script>
<!-- AdminLTE App -->
<script src="dist/js/adminlte.min.js"></script>

<!-- Page specific script -->
<script>
  $(function () {
    $("#example1").DataTable({
      "responsive": true, "lengthChange": false, "autoWidth": false,
      "buttons": ["copy", "csv", "excel", "pdf", "print", "colvis"]
    }).buttons().container().appendTo('#example1_wrapper .col-md-6:eq(0)');
    $('#example2').DataTable({
      "paging": true,
      "lengthChange": false,
      "searching": false,
      "ordering": true,
      "info": true,
      "autoWidth": false,
      "responsive": true,
    });
  });
</script>
</body>
</html>
