<?php
include("config.php");
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Manage Employees - Dyne Foundation</title>

  <!-- Google Font: Source Sans Pro -->
  <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700&display=fallback">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="plugins/fontawesome-free/css/all.min.css">
  <!-- DataTables -->
  <link rel="stylesheet" href="plugins/datatables-bs4/css/dataTables.bootstrap4.min.css">
  <link rel="stylesheet" href="plugins/datatables-responsive/css/responsive.bootstrap4.min.css">
  <link rel="stylesheet" href="plugins/datatables-buttons/css/buttons.bootstrap4.min.css">
  <!-- Theme style -->
  <link rel="stylesheet" href="dist/css/adminlte.min.css">
</head>
<body class="hold-transition sidebar-mini layout-fixed">
<div class="wrapper">
  <!-- Navbar -->
  <?php include("header.php");?>
  <!-- /.navbar -->

  <!-- Main Sidebar Container -->
  <aside class="main-sidebar sidebar-dark-primary elevation-4">
    <?php include("sidebar.php");?>
  </aside>

  <!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1>Manage Employees</h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="dashboard.php">Home</a></li>
              <li class="breadcrumb-item active">Manage Employees</li>
            </ol>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>

    <!-- Main content -->
    <section class="content">
      <div class="container-fluid">
        <div class="row">
          <div class="col-12">
            

            <div class="card">
              <div class="card-header col-12 row d-flex justify-content-between align-items-center">
                  <div class="col-6">
                      <h3 class="card-title">View All Employees</h3>
                  </div>
                <div class="col-6 d-flex justify-content-end">
                    <a class="btn btn-primary" href="newEmployee.php">+ Add New Employee</a>
                </div>
                
              </div>
              <!-- /.card-header -->
              <div class="card-body">
                <table id="example1" class="table table-bordered table-striped">
                  <thead>
                  <tr>
                    <th>Sl No</th>
                    <th>Name</th>
                    
                    
                    <th>Phone</th>
                    <th>Address</th>
                    <th>Department</th>
                    <th>Position</th>
                    <th>Date of Birth</th>
                    <th>Date of Joining</th>
                    <th>Date of Resignation</th>
                    <th>Bank</th>
                    <th>Bank Account No</th>
                    <th>IFSC</th>
                    <th>Branch</th>
                    <th>Documents</th>
                  </tr>
                  </thead>
                  <tbody>
                      <?php
                      $sql=mysqli_query($db,"select employees.*,department.deptname from employees,department where department.id=employees.dept");
                      $sl=0;
                      if(mysqli_num_rows($sql))
                      {
                          while($row=mysqli_fetch_assoc($sql))
                          {$sl=$sl+1;
                              ?>
                              <tr ondblclick="window.location.href='newEmployee.php?id=<?php echo $row['id'];?>'">
                                  <td><?php echo $sl;?></td>
                    <td><?php echo $row['name'];?></td>
                    <td><?php echo $row['phone'];?></td>
                    <td><?php echo $row['address'];?></td>
                    <td><?php echo $row['deptname'];?></td>
                    <td><?php echo $row['position'];?></td>
                    <td><?php echo $row['dob'];?></td>
                    <td><?php echo $row['doj'];?></td>
                    <td><?php echo $row['dor'];?></td>
                    <td><?php echo $row['bank'];?></td>
                    <td><?php echo $row['bankacc'];?></td>
                    <td><?php echo $row['ifsc'];?></td>
                    <td><?php echo $row['branch'];?></td>
                    <td>
                        <?php
                        $emid=$row['id'];
                        
                        $dsql=mysqli_query($db,"select * from emp_docs where emid='$emid' ");
                        if(mysqli_num_rows($dsql))
                        {
                            while($drow=mysqli_fetch_assoc($dsql))
                            {
                                ?>
                                <a href="<?php echo $drow['docs'];?>" target="_blank"><?php echo $drow['docs'];?></a><br>
                                <?php
                            }
                        }
                        ?>
                    </td>
                  </tr>
                              <?php
                          }
                      }
                      ?>
                  
                 
                </table>
              </div>
              <!-- /.card-body -->
            </div>
            <!-- /.card -->
          </div>
          <!-- /.col -->
        </div>
        <!-- /.row -->
      </div>
      <!-- /.container-fluid -->
    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->
  <footer class="main-footer">
    <?php include("footer.php");?>
  </footer>

  <!-- Control Sidebar -->
  <aside class="control-sidebar control-sidebar-dark">
    <!-- Control sidebar content goes here -->
  </aside>
  <!-- /.control-sidebar -->
</div>
<!-- ./wrapper -->

<!-- jQuery -->
<script src="plugins/jquery/jquery.min.js"></script>
<!-- Bootstrap 4 -->
<script src="plugins/bootstrap/js/bootstrap.bundle.min.js"></script>
<!-- DataTables  & Plugins -->
<script src="plugins/datatables/jquery.dataTables.min.js"></script>
<script src="plugins/datatables-bs4/js/dataTables.bootstrap4.min.js"></script>
<script src="plugins/datatables-responsive/js/dataTables.responsive.min.js"></script>
<script src="plugins/datatables-responsive/js/responsive.bootstrap4.min.js"></script>
<script src="plugins/datatables-buttons/js/dataTables.buttons.min.js"></script>
<script src="plugins/datatables-buttons/js/buttons.bootstrap4.min.js"></script>
<script src="plugins/jszip/jszip.min.js"></script>
<script src="plugins/pdfmake/pdfmake.min.js"></script>
<script src="plugins/pdfmake/vfs_fonts.js"></script>
<script src="plugins/datatables-buttons/js/buttons.html5.min.js"></script>
<script src="plugins/datatables-buttons/js/buttons.print.min.js"></script>
<script src="plugins/datatables-buttons/js/buttons.colVis.min.js"></script>
<!-- AdminLTE App -->
<script src="dist/js/adminlte.min.js"></script>

<!-- Page specific script -->
<script>
  $(function () {
    $("#example1").DataTable({
      "responsive": true, "lengthChange": false, "autoWidth": false,
      "buttons": ["copy", "csv", "excel", "pdf", "print", "colvis"]
    }).buttons().container().appendTo('#example1_wrapper .col-md-6:eq(0)');
    $('#example2').DataTable({
      "paging": true,
      "lengthChange": false,
      "searching": false,
      "ordering": true,
      "info": true,
      "autoWidth": false,
      "responsive": true,
    });
  });
</script>
</body>
</html>
